/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagAppender;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    private static final Gson f_126542_ = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator f_126539_;
    protected final Registry<T> f_126540_;
    protected final Map<ResourceLocation, Tag.Builder> f_126543_ = Maps.newLinkedHashMap();
    protected final String modId;
    protected final String folder;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;

    @Deprecated
    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_) {
        this(p_126546_, p_126547_, "vanilla", null);
    }

    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this(p_126546_, p_126547_, modId, existingFileHelper, null);
    }

    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_, String modId, @Nullable ExistingFileHelper existingFileHelper, @Nullable String folder) {
        this.f_126539_ = p_126546_;
        this.f_126540_ = p_126547_;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        if (folder == null) {
            folder = Registry.f_122897_.m_7981_(this.f_126540_).m_135815_() + "s";
        }
        this.folder = folder;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "tags/" + this.folder);
    }

    protected abstract void m_6577_();

    public void m_6865_(HashCache p_126554_) {
        this.f_126543_.clear();
        this.m_6577_();
        this.f_126543_.forEach((p_176835_, p_176836_) -> {
            List list = p_176836_.m_13330_().filter(p_176832_ -> !p_176832_.f_13338_().m_142746_(this.f_126540_::m_7804_, this.f_126543_::containsKey)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", p_176835_, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonobject = p_176836_.m_13334_();
            Path path = this.m_6648_((ResourceLocation)p_176835_);
            if (path == null) {
                return;
            }
            try {
                String s = f_126542_.toJson((JsonElement)jsonobject);
                String s1 = f_123918_.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(p_126554_.m_123938_(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                p_126554_.m_123940_(path, s1);
            }
            catch (IOException ioexception) {
                f_126541_.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(Tag.BuilderEntry reference) {
        Tag.Entry entry = reference.f_13338_();
        if (entry instanceof Tag.TagEntry) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(((Tag.TagEntry)entry).getId(), this.resourceType);
        }
        return false;
    }

    protected Path m_6648_(ResourceLocation p_126561_) {
        ResourceKey<Registry<T>> resourcekey = this.f_126540_.m_123023_();
        return this.f_126539_.m_123916_().resolve("data/" + p_126561_.m_135827_() + "/" + TagManager.m_203918_(resourcekey) + "/" + p_126561_.m_135815_() + ".json");
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        Tag.Builder tag$builder = this.m_206426_(p_206425_);
        return new TagAppender<T>(tag$builder, this.f_126540_, this.modId);
    }

    protected Tag.Builder m_206426_(TagKey<T> p_206427_) {
        return this.f_126543_.computeIfAbsent(p_206427_.f_203868_(), p_176838_ -> {
            this.existingFileHelper.trackGenerated(p_176838_, this.resourceType);
            return new Tag.Builder();
        });
    }

    public static class TagAppender<T>
    implements IForgeTagAppender<T> {
        private final Tag.Builder f_126568_;
        public final Registry<T> f_126569_;
        private final String f_126570_;

        TagAppender(Tag.Builder p_126572_, Registry<T> p_126573_, String p_126574_) {
            this.f_126568_ = p_126572_;
            this.f_126569_ = p_126573_;
            this.f_126570_ = p_126574_;
        }

        public TagAppender<T> m_126582_(T p_126583_) {
            this.f_126568_.m_13327_(this.f_126569_.m_7981_(p_126583_), this.f_126570_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> resourcekey : p_211102_) {
                this.f_126568_.m_13327_(resourcekey.m_135782_(), this.f_126570_);
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_144379_(p_176840_, this.f_126570_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_13335_(p_206429_.f_203868_(), this.f_126570_);
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_144382_(p_176842_, this.f_126570_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_126584_(T ... p_126585_) {
            Stream.of(p_126585_).map(this.f_126569_::m_7981_).forEach(p_126587_ -> this.f_126568_.m_13327_((ResourceLocation)p_126587_, this.f_126570_));
            return this;
        }

        public TagAppender<T> add(Tag.Entry tag) {
            this.f_126568_.m_13307_(tag, this.f_126570_);
            return this;
        }

        public Tag.Builder getInternalBuilder() {
            return this.f_126568_;
        }

        public String getModID() {
            return this.f_126570_;
        }
    }
}

